-- 1.
select e.first_name, e.last_name, j.job_title, l.city
  from employees e
  join jobs j on e.job_id = j.job_id
  join departments d on e.department_id = d.department_id
  join locations l on d.location_id = l.location_id
 where l.city = 'Munich';
 

-- 2.
select d.department_name, l.city
  from departments d
  join locations l on d.location_id = l.location_id
  join countries c on l.country_id = c.country_id
 where c.country_name = 'United States of America';
 
-- 3.
select e.first_name, e.last_name, j.job_title, e.salary, d.department_name
  from employees e 
  join jobs j on e.job_id = j.job_id
  join departments d on e.department_id = d.department_id
 where e.salary between 10000 and 20000
   and j.job_title not like '%Manager%';
   
-- 4.
-- Achten Sie auf Kimberley Grant!
select e.first_name, e.last_name, d.department_name
  from employees e
  left join departments d on e.department_id = d.department_id
 where e.last_name like 'G%';

-- 5.
-- Warum benötigen wir hier keinen Outer Join?
select distinct d.department_name
  from departments d
  join employees e on d.department_id = e.department_id
 where e.salary < 6000;

-- 6.
-- Ist Kimberly Grant etwa schon wieder nicht dabei?
select j.job_title, e.first_name, e.last_name, d.department_name
  from employees e
  join jobs j on e.job_id = j.job_id
  left join departments d on e.department_id = d.department_id
 where job_title like 'Sales%';

-- 7.
-- Das war ein bisschen hinterhältig. Mitarbeiter in ihrer ursprünglichen 
-- Position haben keinen Eintrag in der JOB_HISTORY, daher benötigen wir
-- hierauf einen Outer Join und müssen Matches ausschließen
select e.first_name, e.last_name, e.salary
  from employees e
  left join job_history j on e.employee_id = j.employee_id
 where e.salary > 10000
   and j.employee_id is null;
 